unit ThrdServer;

interface

uses Windows, sysutils, Contnrs, messages, classes, SyncObjs, IBAccess;

const
  AM_ThreadReturn = WM_APP + 434;
  AM_Type_ServerObj = 1;


type
  TSrverTaskObj = class(Tobject)
    SqlCommand: string;
    Results: T2dString;
    FmHandle: THandle;
    constructor Create;
    destructor Destroy; override;
  end;

  TBaseServerThread = class(TThread)
  private
    FLock: TCriticalSection;
    FTaskList: TObjectList;
    procedure StartUp;
    procedure LogError(AErrorTxt: string);
  protected
    procedure PostReturnServerObj(AServerObj: TSrverTaskObj);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Push(ASrverObj: TSrverTaskObj);
    function Pop: TSrverTaskObj;
  end;

implementation

{ TBaseServerThread }

constructor TBaseServerThread.Create;
begin
  Flock := TCriticalSection.Create;
  FTaskList := TObjectList.Create(true);
  inherited Create(True);
end;


destructor TBaseServerThread.Destroy;
begin
  Try
  StartUp;
  Terminate;
  Flock.Free;
  FTaskList.Free;
  Except end;
  inherited;
end;

procedure TBaseServerThread.LogError(AErrorTxt: string);
begin

end;

function TBaseServerThread.Pop: TSrverTaskObj;
begin
  FLock.Acquire;
  try
    if FTaskList.Count = 0 then
      result := nil
    else
    begin
      Pointer(Result) := FTaskList.First;
      FTaskList.Extract(Result);
    end
  finally
    FLock.Release;
  end;
end;

procedure TBaseServerThread.PostReturnServerObj(AServerObj: TSrverTaskObj);
begin
  if AServerObj = nil then exit;
  if AServerObj.FmHandle = 0 then
    AServerObj.Free
  else
    if not PostMessage(AServerObj.FmHandle, AM_ThreadReturn, //Message Number
      AM_Type_ServerObj, //wParam
      LongInt(AServerObj)) //LParam
      then
    begin
      LogError('Failed to Post Result::' + IntToStr(GetLastError));
      AServerObj.Free;
    end;
end;

procedure TBaseServerThread.Push(ASrverObj: TSrverTaskObj);
begin
  FLock.Acquire;
  try
    if Terminated then
       raise Exception.Create('Thread Closed');
    FTaskList.Add(ASrverObj);
    StartUp;
  finally
    FLock.Release;
  end;
end;

procedure TBaseServerThread.StartUp;
begin
  if Suspended then Resume;
end;

{ TSrverTaskObj }
var
  CountOfTSrverTaskObj: Integer = 0;

constructor TSrverTaskObj.Create;
begin
  Inc(CountOfTSrverTaskObj);
end;


destructor TSrverTaskObj.Destroy;
begin
  Dec(CountOfTSrverTaskObj);
  inherited;
end;

initialization

finalization
  while CountOfTSrverTaskObj > 0 do
  begin
    OutputDebugString('Left over TSrverTaskObj');
    Dec(CountOfTSrverTaskObj);
  end;
end.

